package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dto.DataTypeDTO;
import gov.va.genisis2.model.DataType;

/**
 * @author Getaneh Kassahun
 * 
 */

public class DataTypeConverterTest extends AbstractMockMvcTests {

	DataTypeConverter dataTypeConverter;

	@Before
	public void setUp() {
		dataTypeConverter = new DataTypeConverter();
	}

	@Test
	public void convert() {

		DataType dataType = new DataType();

		dataType.setId(1);
		dataType.setDescription("Aggregate Data");

		assertEquals("Aggregate Data", dataTypeConverter.convert(dataType).getDescription());

	}

	@Test
	public void convert2() {
		DataTypeDTO dataTypeDto = new DataTypeDTO();

		dataTypeDto.setId(1);
		dataTypeDto.setDescription("Aggregate Data");
		assertEquals("Aggregate Data", dataTypeConverter.convert(dataTypeDto).getDescription());
	}

	@Test
	public void convertDataTypes() {
		List<DataType> dataTypes = new ArrayList<>();

		DataType dataType = new DataType();

		dataType.setId(1);
		dataType.setDescription("Aggregate Data");
		dataTypes.add(dataType);

		assertTrue(dataTypeConverter.convertDataTypes(dataTypes).size() > 0);
	}

}
